<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasAuthors;

class ProductionLog extends Model
{
    use HasAuthors, \App\Traits\Auditable;

    protected $fillable = [
        'source_batch_id',
        // 'source_initial_weight', // Removed to bypass migration issue
        'production_date',
        'used_weight',
        'output_total_weight',
        'scrap_weight',
        'remarks',
    ];

    public function sourceBatch()
    {
        return $this->belongsTo(StockBatch::class, 'source_batch_id');
    }
}
