<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasAuthors;
use App\Traits\Auditable;

class SalesOrder extends Model
{
    use HasFactory, HasAuthors, Auditable;

    protected $guarded = [];

    public function items()
    {
        return $this->hasMany(SalesOrderItem::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class)->withTrashed();
    }

    public function payments()
    {
        return $this->hasMany(SalesPayment::class);
    }
}
