<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sub_sizes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('size_id')->constrained()->cascadeOnDelete();
            $table->string('name'); // e.g. 6x3, 6x6
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sub_sizes');
    }
};
