<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('production_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('source_batch_id')->constrained('stock_batches');
            $table->decimal('used_weight', 10, 2);
            $table->decimal('output_total_weight', 10, 2);
            $table->decimal('scrap_weight', 10, 2);
            // Optional: Store JSON of output details if we want a quick snapshot
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('production_logs');
    }
};
