<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // We need to use raw SQL for modifying ENUM in MySQL as Doctrine DBAL has issues with it sometimes
        DB::statement("ALTER TABLE sales_orders MODIFY COLUMN payment_status ENUM('PAID', 'UNPAID', 'PARTIAL') DEFAULT 'UNPAID'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Warning: This will truncate 'PARTIAL' values to empty or throw error if data exists.
        // For development, we assume it's fine or we'd map them back to UNPAID.
        DB::statement("UPDATE sales_orders SET payment_status = 'UNPAID' WHERE payment_status = 'PARTIAL'");
        DB::statement("ALTER TABLE sales_orders MODIFY COLUMN payment_status ENUM('PAID', 'UNPAID') DEFAULT 'UNPAID'");
    }
};
