<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasAuthors;
use App\Traits\Auditable;

class StockBatch extends Model
{
    use HasFactory, HasAuthors, Auditable;

    protected $guarded = [];

    public function size()
    {
        return $this->belongsTo(Size::class)->withTrashed();
    }

    public function subSize()
    {
        return $this->belongsTo(SubSize::class)->withTrashed();
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class)->withTrashed();
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'source_id');
    }

    protected $casts = [
        'received_date' => 'date',
        'is_active' => 'boolean',
        'is_void' => 'boolean',
    ];
}
