<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_damages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('batch_id')->constrained('stock_batches')->onDelete('cascade');
            $table->string('batch_no');
            $table->decimal('quantity_pieces', 10, 2);
            $table->decimal('weight_kg', 10, 2);
            $table->string('reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_damages');
    }
};
