<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_orders', function (Blueprint $table) {
            $table->date('invoice_date')->nullable()->after('invoice_no');
        });

        Schema::table('production_logs', function (Blueprint $table) {
            $table->date('production_date')->nullable()->after('id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_orders', function (Blueprint $table) {
            $table->dropColumn('invoice_date');
        });

        Schema::table('production_logs', function (Blueprint $table) {
            $table->dropColumn('production_date');
        });
    }
};
