<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('action'); // CREATE, UPDATE, DELETE, LOGIN, OTHER
            $table->string('module'); // Stock, Sales, Customer, etc.
            $table->text('description'); // "Created Initial Stock for Batch B-101"
            $table->string('resource_type')->nullable(); // App\Models\StockBatch
            $table->unsignedBigInteger('resource_id')->nullable();
            $table->json('metadata')->nullable(); // Changes, etc.
            $table->string('ip_address')->nullable();
            $table->timestamps();

            $table->index(['resource_type', 'resource_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audit_logs');
    }
};
