<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Using raw SQL to avoid doctrine/dbal dependency and ensure compatibility
        // IF the column is already nullable (manual fix), this will just run without error in MySQL
        DB::statement("ALTER TABLE suppliers MODIFY gst_no VARCHAR(255) NULL");
        DB::statement("ALTER TABLE customers MODIFY gst_no VARCHAR(255) NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reverting back to NOT NULL if needed (careful with data loss if nulls exist)
        // DB::statement("ALTER TABLE suppliers MODIFY gst_no VARCHAR(255) NOT NULL");
        // DB::statement("ALTER TABLE customers MODIFY gst_no VARCHAR(255) NOT NULL");
    }
};
